within ;
model Transmission
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=0.05)
    annotation (Placement(transformation(extent={{-80,-4},{-60,16}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_b flange_b annotation (
      Placement(transformation(extent={{86,-8},{106,12}}), iconTransformation(
          extent={{90,-10},{110,10}})));
  Modelica.Blocks.Interfaces.RealInput g1
                                         annotation (Placement(transformation(
          extent={{-96,56},{-56,96}}),  iconTransformation(extent={{20,20},{-20,
            -20}},
        rotation=90,
        origin={0,76})));

  Modelica.Mechanics.Rotational.Components.Clutch clutch(fn_max=1000)
    annotation (Placement(transformation(extent={{-38,50},{-18,70}})));
  Modelica.Mechanics.Rotational.Components.IdealGear idealGear(ratio=2.5)
    annotation (Placement(transformation(extent={{-6,50},{14,70}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a
    annotation (Placement(transformation(extent={{-104,-4},{-84,16}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia1(J=0.05)
    annotation (Placement(transformation(extent={{64,-8},{84,12}})));
  Modelica.Blocks.Interfaces.RealInput g2
    annotation (Placement(transformation(extent={{-96,12},{-56,52}})));
  Modelica.Blocks.Interfaces.RealInput g3
    annotation (Placement(transformation(extent={{-96,-56},{-56,-16}})));
  Modelica.Blocks.Interfaces.RealInput g4
    annotation (Placement(transformation(extent={{-96,-98},{-56,-58}})));
  Modelica.Mechanics.Rotational.Components.Clutch clutch1(
                                                         fn_max=1000)
    annotation (Placement(transformation(extent={{-38,-4},{-18,16}})));
  Modelica.Mechanics.Rotational.Components.IdealGear idealGear1(ratio=1.5)
    annotation (Placement(transformation(extent={{-4,-4},{16,16}})));
  Modelica.Mechanics.Rotational.Components.Spring spring(c=1e5)
    annotation (Placement(transformation(extent={{38,-10},{58,12}})));
  Modelica.Mechanics.Rotational.Components.Clutch clutch2(
                                                         fn_max=1000)
    annotation (Placement(transformation(extent={{-38,-34},{-18,-14}})));
  Modelica.Mechanics.Rotational.Components.Clutch clutch3(
                                                         fn_max=1000)
    annotation (Placement(transformation(extent={{-38,-68},{-18,-48}})));
  Modelica.Mechanics.Rotational.Components.IdealGear idealGear2(ratio=1.0)
    annotation (Placement(transformation(extent={{-4,-34},{16,-14}})));
  Modelica.Mechanics.Rotational.Components.IdealGear idealGear3(ratio=0.75)
    annotation (Placement(transformation(extent={{-4,-68},{16,-48}})));
equation
//  clutch.f_normalized := 1.0;
  //clutch1.f_normalized := 0.0;
  //clutch2.f_normalized := 0.0;
  //clutch3.f_normalized := 0.0;
  //clutch4.f_normalized = 0.0;

  connect(inertia.flange_a, flange_a) annotation (Line(
      points={{-80,6},{-94,6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia1.flange_b, flange_b) annotation (Line(
      points={{84,2},{96,2}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(g2, clutch1.f_normalized) annotation (Line(
      points={{-76,32},{-28,32},{-28,17}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(clutch.f_normalized, g1)
                                  annotation (Line(
      points={{-28,71},{-28,76},{-76,76}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(inertia.flange_b, clutch1.flange_a) annotation (Line(
      points={{-60,6},{-38,6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia.flange_b, clutch.flange_a) annotation (Line(
      points={{-60,6},{-50,6},{-50,60},{-38,60}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(clutch1.flange_b, idealGear1.flange_a) annotation (Line(
      points={{-18,6},{-4,6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(clutch.flange_b, idealGear.flange_a) annotation (Line(
      points={{-18,60},{-6,60}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(idealGear1.flange_b, spring.flange_a) annotation (Line(
      points={{16,6},{24,6},{24,1},{38,1}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(spring.flange_b, inertia1.flange_a) annotation (Line(
      points={{58,1},{57,1},{57,2},{64,2}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(idealGear.flange_b, spring.flange_a) annotation (Line(
      points={{14,60},{26,60},{26,1},{38,1}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(clutch2.f_normalized, g3) annotation (Line(
      points={{-28,-13},{-46,-13},{-46,-36},{-76,-36}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(clutch3.f_normalized, g4) annotation (Line(
      points={{-28,-47},{-48,-47},{-48,-78},{-76,-78}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(clutch2.flange_a, inertia.flange_b) annotation (Line(
      points={{-38,-24},{-50,-24},{-50,6},{-60,6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(clutch3.flange_a, inertia.flange_b) annotation (Line(
      points={{-38,-58},{-50,-58},{-50,6},{-60,6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(clutch2.flange_b, idealGear2.flange_a) annotation (Line(
      points={{-18,-24},{-4,-24}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(clutch3.flange_b, idealGear3.flange_a) annotation (Line(
      points={{-18,-58},{-4,-58}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(idealGear2.flange_b, spring.flange_a) annotation (Line(
      points={{16,-24},{30,-24},{30,1},{38,1}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(idealGear3.flange_b, spring.flange_a) annotation (Line(
      points={{16,-58},{34,-58},{34,1},{38,1}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")),
    Diagram(graphics),
    Icon(graphics={Text(
          extent={{-70,86},{82,-66}},
          lineColor={0,0,255},
          textString="Transmission")}));
end Transmission;
